
import gurobi

def solve_paint_blend_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="cheap_paint", lb=0, ub=1)
    y = model.addVar(name="expensive_paint", lb=0, ub=1)

    # Define the objective function
    model.setObjective(0.30 * x + 1.50 * y, gurobi.GRB.MINIMIZE)

    # Add the quality rating constraint
    model.addConstr(50 * x + 90 * y >= 80, name="quality_rating")

    # Add the constraint that the fractions add up to 1
    model.addConstr(x + y == 1, name="fractions_add_up_to_1")

    # Optimize the model
    model.optimize()

    # Check if the model is infeasible
    if model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The problem is infeasible")
        return

    # Print the solution
    print("Optimal blend:")
    print(f"Cheap paint: {x.varValue:.4f}")
    print(f"Expensive paint: {y.varValue:.4f}")
    print(f"Cost: {model.objVal:.4f}")

solve_paint_blend_problem()
