
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Clothing_Store")

# Create variables
c = m.addVar(lb=0, vtype=GRB.INTEGER, name="coats")  # Integer number of coats
s = m.addVar(lb=0, vtype=GRB.INTEGER, name="shirts") # Integer number of shirts

# Set objective function
m.setObjective(12*c + 8*s, GRB.MAXIMIZE)

# Add constraints
m.addConstr(55*c + 25*s <= 50000, "budget")
m.addConstr(c >= 60, "min_coats")
m.addConstr(c <= 100, "max_coats")
m.addConstr(s <= 4*c, "shirt_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of coats to sell: {c.x}")
    print(f"Number of shirts to sell: {s.x}")
    print(f"Maximum profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

