
from gurobipy import *

# Create a model
m = Model("Clothing_Store_Optimization")

# Define the decision variables
C = m.addVar(lb=60, ub=100, vtype=GRB.INTEGER, name="Coats")
S = m.addVar(vtype=GRB.INTEGER, name="Shirts")

# Objective function: Maximize profit
m.setObjective(12*C + 8*S, GRB.MAXIMIZE)

# Constraints
m.addConstr(55*C + 25*S <= 50000, "Budget_Constraint")
m.addConstr(S <= 4*C, "Shirt_vs_Coat_Constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coats to sell: {C.x}")
    print(f"Shirts to sell: {S.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
