
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    C = model.addVar(lb=60, ub=100, name="Coats")  # At least 60, at most 100 coats
    S = model.addVar(name="Shirts")  # No explicit bounds for shirts

    # Objective function: Maximize profit
    model.setObjective(12*C + 8*S, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(55*C + 25*S <= 50000, name="Budget")

    # Shirts sold is at most four times the number of coats sold
    model.addConstr(S <= 4*C, name="Shirt_vs_Coat")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Coats = {C.varValue}, Shirts = {S.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
