
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("SyrupProduction")

# Create decision variables
x = m.addVar(lb=0, ub=15, name="chocolate_syrup")
y = m.addVar(lb=0, ub=15, name="caramel_syrup")

# Set objective function
m.setObjective(500*x + 350*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 2, "min_chocolate")
m.addConstr(y >= 3, "min_caramel")
m.addConstr(3*x + 3*y <= 50, "heating_machine_time")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Chocolate Syrup: {x.x} tons")
    print(f"Caramel Syrup: {y.x} tons")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

