
from gurobipy import *

# Create a new model
model = Model("Syrup_Factory")

# Decision variables
x_c = model.addVar(lb=2, ub=15, vtype=GRB.CONTINUOUS, name="Chocolate_Syrup")
x_cm = model.addVar(lb=3, ub=15, vtype=GRB.CONTINUOUS, name="Caramel_Syrup")

# Objective function
model.setObjective(500*x_c + 350*x_cm, GRB.MAXIMIZE)

# Constraints
model.addConstr(x_c <= 15, "Max_Chocolate")
model.addConstr(x_cm <= 15, "Max_Caramel")
model.addConstr(3*x_c + 3*x_cm <= 50, "Heating_Machine")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate Syrup: {x_c.x} tons")
    print(f"Caramel Syrup: {x_cm.x} tons")
    print(f"Maximum Profit: ${model.objVal}")
else:
    print("No optimal solution found.")
