
import gurobi

def solve_syrup_factory_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=2, ub=15, name="chocolate_syrup")  # tons of chocolate syrup
    y = model.addVar(lb=3, ub=15, name="caramel_syrup")  # tons of caramel syrup

    # Objective function: Maximize profit
    model.setObjective(500 * x + 350 * y, gurobi.GRB.MAXIMIZE)

    # Heating machine constraint
    model.addConstr(3 * x + 3 * y <= 50, name="heating_machine_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Chocolate syrup = {x.varValue} tons, Caramel syrup = {y.varValue} tons")
        print(f"Maximum profit: ${model.objVal}")
    else:
        print("The model is infeasible.")

# Run the function
solve_syrup_factory_problem()
