
import gurobipy as gp
from gurobipy import GRB

try:

    # Create a new model
    m = gp.Model("farm_optimization")

    # Create variables
    x = m.addVar(nonnegative=True, name="corn")
    y = m.addVar(nonnegative=True, name="wheat")

    # Set objective
    m.setObjective(200*x + 300*y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 40, "land")
    m.addConstr(x >= 6, "min_corn")
    m.addConstr(y >= 12, "min_wheat")
    m.addConstr(x <= 2*y, "corn_wheat_ratio")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Plant {x.x:.2f} acres of corn")
        print(f"Plant {y.x:.2f} acres of wheat")
        print(f"Maximum Profit: ${m.objVal:.2f}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}.")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
