
from gurobipy import *

# Create a new model
m = Model("Farm_Optimization")

# Define the decision variables
C = m.addVar(name='Corn', lb=0)
W = m.addVar(name='Wheat', lb=0)

# Set the objective function to maximize profit
m.setObjective(200*C + 300*W, GRB.MAXIMIZE)

# Add constraints
m.addConstr(C + W <= 40, name='Total_Land')
m.addConstr(C >= 6, name='Min_Corn')
m.addConstr(W >= 12, name='Min_Wheat')
m.addConstr(C <= 2*W, name='Corn_to_Wheat_Ratio')

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Corn acres: {C.x}")
    print(f"Wheat acres: {W.x}")
    print(f"Maximum profit: ${200*C.x + 300*W.x}")
else:
    print("No optimal solution found")
