
import gurobi

def solve_farmer_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    C = m.addVar(name="corn", lb=0)  # Acres of corn
    W = m.addVar(name="wheat", lb=0)  # Acres of wheat

    # Objective function: Maximize profit
    m.setObjective(200*C + 300*W, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(C >= 6, name="min_corn")
    m.addConstr(W >= 12, name="min_wheat")
    m.addConstr(C <= 2*W, name="corn_to_wheat_ratio")
    m.addConstr(C + W <= 40, name="total_land")

    # Solve the problem
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of corn: {C.varValue}")
        print(f"Optimal acres of wheat: {W.varValue}")
        print(f"Maximum profit: ${200*C.varValue + 300*W.varValue}")
    else:
        print("The problem is infeasible")

solve_farmer_problem()
