
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("CerealProduction")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="individual_boxes") # Integer number of boxes
y = m.addVar(vtype=GRB.INTEGER, name="family_boxes") # Integer number of boxes

# Set objective function
m.setObjective(4*x + 8*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 60*y <= 2000, "cereal_constraint")
m.addConstr(10*x + 15*y <= 750, "time_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of individual boxes: {x.x}")
    print(f"Number of family boxes: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

