
from gurobipy import *

# Create a new model
m = Model("Cereal_Box_Optimization")

# Define variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="individual_boxes")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="family_size_boxes")

# Set the objective function: Maximize profit
m.setObjective(4*x + 8*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 60*y <= 2000, "cereal_limit")
m.addConstr(10*x + 15*y <= 750, "time_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")
