
import gurobi as gp

# Create a new model
m = gp.Model("Cereal_Production")

# Define variables
x = m.addVar(lb=0, name="individual_cereal_boxes")  # Number of individual cereal boxes
y = m.addVar(lb=0, name="family_size_cereal_boxes")  # Number of family size cereal boxes

# Objective function: Maximize profit
m.setObjective(4*x + 8*y, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(20*x + 60*y <= 2000, name="cereal_constraint")  # Cereal units constraint
m.addConstr(10*x + 15*y <= 750, name="filling_time_constraint")  # Filling time constraint

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Production levels: individual boxes = {x.varValue}, family size boxes = {y.varValue}")
    print(f"Maximum profit: ${4*x.varValue + 8*y.varValue:.2f}")
else:
    print("No optimal solution found.")
