
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("cyclist_diet")

# Create variables
chicken = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken")
potatoes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")

# Set objective function
m.setObjective(6 * chicken + 2 * potatoes, GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * chicken + 2 * potatoes >= 80, "protein")
m.addConstr(4 * chicken + 3 * potatoes >= 50, "fat")
m.addConstr(4 * chicken + 7 * potatoes >= 100, "carbs")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of chickens: {chicken.x:.2f}")
    print(f"Number of potatoes: {potatoes.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

