
from gurobipy import *

# Create a new model
model = Model("Cyclist_Diet")

# Define the decision variables
chicken = model.addVar(vtype=GRB.CONTINUOUS, name="chicken", lb=0)
potatoes = model.addVar(vtype=GRB.CONTINUOUS, name="potatoes", lb=0)

# Define the objective function
model.setObjective(6*chicken + 2*potatoes, GRB.MINIMIZE)

# Add the nutritional constraints
model.addConstr(20*chicken + 2*potatoes >= 80, "protein")
model.addConstr(4*chicken + 3*potatoes >= 50, "fat")
model.addConstr(4*chicken + 7*potatoes >= 100, "carbs")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Number of chickens to buy:", chicken.x)
    print("Number of potatoes to buy:", potatoes.x)
    print("Total cost: $", model.objVal)
else:
    print("No optimal solution found.")
