
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(name="oranges") # Acres of oranges
y = m.addVar(name="grapefruits") # Acres of grapefruits

# Set objective function
m.setObjective(200*x + 220*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "land_constraint")
m.addConstr(x >= 60, "min_oranges")
m.addConstr(y >= 50, "min_grapefruits")
m.addConstr(y <= 2*x, "grapefruit_orange_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Oranges: {x.x}")
    print(f"Acres of Grapefruits: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

