
import gurobi

def solve_farmer_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="acres_of_oranges")
    y = model.addVar(lb=0, name="acres_of_grapefruits")

    # Objective function: Maximize profit
    model.setObjective(200*x + 220*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x >= 60, name="min_oranges")
    model.addConstr(y >= 50, name="min_grapefruits")
    model.addConstr(y >= x, name="more_grapefruits_than_oranges")
    model.addConstr(y <= 2*x, name="at_most_twice_grapefruits")
    model.addConstr(x + y <= 200, name="total_land")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of oranges: {x.varValue}")
        print(f"Optimal acres of grapefruits: {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_farmer_problem()
