
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ToyProduction")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="action_figures") # Allowing fractional toys for now
y = m.addVar(vtype=GRB.CONTINUOUS, name="toy_cars")

# Set objective
m.setObjective(2*x + 3*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 8*y <= 1000, "production_time")
m.addConstr(2*x + 2.5*y <= 1000, "plastic_cost")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of action figures: {x.x}")
    print(f"Number of toy cars: {y.x}")
    print(f"Maximum Earnings: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

