
from gurobipy import *

# Create a model
m = Model("Action_Figures_and_Toy_Cars")

# Define decision variables
x = m.addVar(name="action_figures", lb=0)
y = m.addVar(name="toy_cars", lb=0)

# Set the objective function to maximize earnings
m.setObjective(2*x + 3*y, GRB.MAXIMIZE)

# Add production time constraint
m.addConstr(5*x + 8*y <= 1000, name="production_time")

# Add plastic cost constraint
m.addConstr(2*x + 2.50*y <= 1000, name="plastic_cost")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum earnings: {2*x.x + 3*y.x}")
else:
    print("No optimal solution found")
