
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="action_figures", vtype=gurobi.GRB.INTEGER)
    y = model.addVar(name="toy_cars", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize earnings
    model.setObjective(2 * x + 3 * y, sense=gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x + 8 * y <= 1000, name="production_time")
    model.addConstr(2 * x + 2.5 * y <= 1000, name="plastic_cost")
    model.addConstr(x >= 0, name="non_negativity_x")
    model.addConstr(y >= 0, name="non_negativity_y")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: action figures = {x.varValue}, toy cars = {y.varValue}")
        print(f"Max earnings: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_production_problem()
