
import gurobipy as gp

# Create a new model
model = gp.Model("DoseOptimization")

# Create decision variables
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="youth_doses") # Integer number of youth doses
a = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="adult_doses") # Integer number of adult doses


# Set objective function
model.setObjective(5*y + 3*a, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*y + 35*a <= 5000, "extract_constraint")
model.addConstr(y >= 3*a, "demand_constraint")
model.addConstr(a >= 10, "min_adult_doses")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Youth Doses: {y.x}")
    print(f"Number of Adult Doses: {a.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

