
from gurobipy import *

# Create a new model
m = Model("Optimize_Doses")

# Define the variables
y = m.addVar(vtype=GRB.CONTINUOUS, name="YouthDoses")
a = m.addVar(vtype=GRB.CONTINUOUS, name="AdultDoses")

# Set the objective function to maximize profit
m.setObjective(5*y + 3*a, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*y + 35*a <= 5000, "ExtractLimit")
m.addConstr(y >= 3*a, "YouthVsAdult")
m.addConstr(a >= 10, "MinimumAdultDoses")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Youth doses: {y.x}")
    print(f"Adult doses: {a.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
