
import gurobipy as gp

# Create a new model
m = gp.Model("Dose_Production")

# Variables
Y = m.addVar(name="Youth_Doses", vtype=gp.GRB.INTEGER)  # Number of youth doses
A = m.addVar(name="Adult_Doses", vtype=gp.GRB.INTEGER)  # Number of adult doses

# Objective function: Maximize profit
m.setObjective(5 * Y + 3 * A, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(20 * Y + 35 * A <= 5000, name="Extract_Limitation")  # Extract limitation
m.addConstr(Y >= 3 * A, name="Demand_Constraint")  # Demand constraint
m.addConstr(A >= 10, name="Min_Adult_Doses")  # Minimum adult doses

# Solve the model
m.solve()

# Output the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Youth doses = {Y.varValue}, Adult doses = {A.varValue}")
    print(f"Max Profit: ${5 * Y.varValue + 3 * A.varValue}")
else:
    print("No optimal solution found.")
