
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("TrainProfitMaximization")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="business_class")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="coach_class")

# Set objective function
m.setObjective(300*x + 150*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 600, "total_capacity")
m.addConstr(y <= 4*x, "coach_preference")
m.addConstr(x >= 45, "min_business")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Business Class Tickets: {x.x}")
    print(f"Number of Coach Class Tickets: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

