
from gurobipy import *

# Create a new model
m = Model("Nova_Transport_Optimization")

# Define decision variables
x = m.addVar(lb=45, vtype=GRB.INTEGER, name="business_class_tickets")
y = m.addVar(vtype=GRB.INTEGER, name="coach_class_tickets")

# Define the objective function: Maximize profit
m.setObjective(300*x + 150*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 600, "total_passengers")
m.addConstr(y >= 4*x + 1, "coach_vs_business_ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Business class tickets to sell: {x.x}")
    print(f"Coach class tickets to sell: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("The model is infeasible.")
