
import gurobi

def solve_nova_transport():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, name="Business_Class")
    C = model.addVar(lb=0, name="Coach_Class")

    # Objective function: Maximize profit
    model.setObjective(300*B + 150*C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(B + C <= 600, name="Total_Passengers")
    model.addConstr(C >= 4*B + 1e-6, name="Coach_vs_Business") # Adding a small value to handle strict inequality
    model.addConstr(B >= 45, name="Min_Business_Class")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Business Class Tickets: {B.varValue}")
        print(f"Coach Class Tickets: {C.varValue}")
        print(f"Maximum Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_nova_transport()
