
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("crop_optimization")

# Create decision variables
x = m.addVar(lb=0, name="corn_acres")
y = m.addVar(lb=0, name="pea_acres")

# Set objective function
m.setObjective(200*x + 250*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 40, "land_constraint")
m.addConstr(50*x + 60*y <= 4350, "fertilizer_cost_constraint")
m.addConstr(60*x + 90*y <= 6000, "time_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of corn")
    print(f"Plant {y.x} acres of peas")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

