
from gurobipy import *

# Create a new model
m = Model("agriculture_optimization")

# Define variables
x = m.addVar(name="corn_acres", lb=0)  # Acres of corn
y = m.addVar(name="peas_acres", lb=0)  # Acres of peas

# Set the objective function: Maximize profit
m.setObjective(200*x + 250*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x + 60*y <= 4350, name="fertilizer_cost_constraint")
m.addConstr(60*x + 90*y <= 6000, name="time_constraint")
m.addConstr(x + y <= 40, name="land_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum Profit: ${200*x.x + 250*y.x:.2f}")
else:
    print("No optimal solution found")
