
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x_c = model.addVar(name="corn", lb=0, ub=40, vtype=gurobi.GRB.CONTINUOUS)
    x_p = model.addVar(name="peas", lb=0, ub=40, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(200 * x_c + 250 * x_p, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x_c + x_p <= 40, name="land_constraint")
    model.addConstr(50 * x_c + 60 * x_p <= 4350, name="fertilizer_constraint")
    model.addConstr(60 * x_c + 90 * x_p <= 6000, name="time_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Acres of corn = {x_c.varValue:.2f}, Acres of peas = {x_p.varValue:.2f}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
