
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("RestaurantStaffing")

# Create decision variables
w = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="waiters") # Number of waiters
m = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="managers") # Number of managers

# Set objective function
model.setObjective(1200*w + 2000*m, GRB.MINIMIZE)

# Add constraints
model.addConstr(w + m >= 50, "min_workers")
model.addConstr(m >= 15, "min_managers")
model.addConstr(3*m >= w, "manager_ratio")
model.addConstr(1200*w + 2000*m <= 500000, "max_wage")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Waiters (w): {w.x}")
    print(f"Number of Managers (m): {m.x}")
    print(f"Minimum Weekly Wage Bill: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

