
from gurobipy import *

# Create a new model
m = Model("FastFoodRestaurant")

# Define the variables
W = m.addVar(vtype=GRB.INTEGER, name="waiters")
M = m.addVar(vtype=GRB.INTEGER, name="managers")

# Set the objective function to minimize the total wage bill
m.setObjective(1200*W + 2000*M, GRB.MINIMIZE)

# Add constraints
m.addConstr(W + M >= 50, "total_workers")
m.addConstr(M >= 15, "min_managers")
m.addConstr(M >= (1/3)*W, "manager_waiter_ratio")
m.addConstr(1200*W + 2000*M <= 500000, "max_wage_bill")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Waiters:", W.x)
    print("Managers:", M.x)
    print("Total Wage Bill: $", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)

