
import gurobi as gp

# Create a new model
m = gp.Model("restaurant_optimization")

# Define the variables
W = m.addVar(name="waiters", lb=0, vtype=gp.GRB.INTEGER)  # Number of waiters
M = m.addVar(name="managers", lb=0, vtype=gp.GRB.INTEGER)  # Number of managers

# Objective: Minimize the total wage bill
m.setObjective(1200 * W + 2000 * M, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(W + M >= 50, name="total_workers")
m.addConstr(M >= 15, name="min_managers")
m.addConstr(M >= W / 3, name="manager_to_waiter_ratio")
m.addConstr(1200 * W + 2000 * M <= 500000, name="wage_bill")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Waiters = {W.varValue}, Managers = {M.varValue}")
    print(f"Minimum Wage Bill: ${1200 * W.varValue + 2000 * M.varValue}")
else:
    print("No optimal solution found")
M.varValue}")
        print(f"Total Wage Bill: ${1200*W.varValue + 2000*M.varValue}")
    else:
        print("The model is infeasible.")

solve_restaurant_staffing_problem()
