
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("TomMusic_Optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="Piano_A")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="Piano_B")

# Set objective function
model.setObjective(32*x + 19*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(20*x + 15*y <= 450, "Budget_Constraint")
model.addConstr(25*x + 10*y >= 250, "Customer_Constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Piano A units: {x.x}")
    print(f"Number of Piano B units: {y.x}")
    print(f"Total Cost: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

