
from gurobipy import *

# Create a new model
m = Model("TomMusic_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.INTEGER, name="Piano_A")
y = m.addVar(vtype=GRB.INTEGER, name="Piano_B")

# Define the objective function: minimize total cost
m.setObjective(32*x + 19*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(25*x + 10*y >= 250, "Attract_at_least_250_customers")
m.addConstr(20*x + 15*y <= 450, "Daily_budget_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Piano A units: {x.x}")
    print(f"Piano B units: {y.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
