
import gurobi

def solve_piano_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, vtype=gurobi.GRB.CONTINUOUS, name="Piano_A")
    y = model.addVar(lb=0, vtype=gurobi.GRB.CONTINUOUS, name="Piano_B")

    # Objective function: Minimize the total cost
    model.setObjective(32*x + 19*y, gurobi.GRB.MINIMIZE)

    # Budget constraint
    model.addConstr(20*x + 15*y <= 450, name="Budget_Constraint")

    # Customer attraction constraint
    model.addConstr(25*x + 10*y >= 250, name="Customer_Constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found")

solve_piano_problem()
