
import gurobipy as gp

# Create a new model
model = gp.Model("sandwich_optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="subs")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="flatbreads")

# Set objective function
model.setObjective(3*x + 2.5*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 4*y <= 2000, "prep_time")
model.addConstr(2*x + y <= 2200, "toast_time")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of subs: {x.x}")
    print(f"Number of flatbreads: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

