
from gurobipy import *

# Create a model
m = Model("Sandwich_Store_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="subs", lb=0)  # Number of subs
y = m.addVar(vtype=GRB.CONTINUOUS, name="flatbreads", lb=0)  # Number of flatbreads

# Define the objective function: Maximize profit
m.setObjective(3*x + 2.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 4*y <= 2000, name="preparation_time")  # Preparation time constraint
m.addConstr(2*x + y <= 2200, name="toasting_time")  # Toasting time constraint

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
