
import gurobi as gp

# Create a new model
m = gp.Model("sandwich_store")

# Define the decision variables
x = m.addVar(name="subs", lb=0, vtype=gp.GRB.CONTINUOUS)  # Number of subs
y = m.addVar(name="flatbreads", lb=0, vtype=gp.GRB.CONTINUOUS)  # Number of flatbreads

# Objective function: Maximize profit
m.setObjective(3*x + 2.5*y, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x + 4*y <= 2000, name="prep_time")  # Preparation time constraint
m.addConstr(2*x + y <= 2200, name="toast_time")  # Toasting time constraint

# Solve the model
m.optimize()

# Check if the model is optimized
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Number of subs: {x.varValue}, Number of flatbreads: {y.varValue}")
    print(f"Max Profit: ${3*x.varValue + 2.5*y.varValue:.2f}")
else:
    print("The model is infeasible or no solution exists.")
