
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("salad_optimization")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="x") # large salads
y = m.addVar(vtype=GRB.CONTINUOUS, name="y") # small salads


# Set objective
m.setObjective(4*x + 2*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(45*x + 30*y <= 1500, "lettuce_constraint")
m.addConstr(10*x + 7*y <= 1200, "sauce_constraint")
m.addConstr(x >= 0, "x_nonneg")
m.addConstr(y >= 0, "y_nonneg")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large salads (x): {x.x}")
    print(f"Number of small salads (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

