
from gurobipy import *

# Create a new model
m = Model("Salad_Shop")

# Define decision variables
L = m.addVar(vtype=GRB.INTEGER, name="Large_Salads")
S = m.addVar(vtype=GRB.INTEGER, name="Small_Salads")

# Set the objective function: Maximize profit
m.setObjective(4*L + 2*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(45*L + 30*S <= 1500, "Lettuce_Constraint")
m.addConstr(10*L + 7*S <= 1200, "Sauce_Constraint")

# Optimize the model
m.optimize()

# Print out the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")

