
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
L = m.addVar(name="Large_Salads", lb=0, ub=None, obj=4)
S = m.addVar(name="Small_Salads", lb=0, ub=None, obj=2)

# Define the constraints
m.addConstr(L * 45 + S * 30 <= 1500, name="Lettuce_Constraint")
m.addConstr(L * 10 + S * 7 <= 1200, name="Sauce_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Optimal solution found.")
    print(f"Large Salads: {L.varValue}")
    print(f"Small Salads: {S.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
