
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tea_shop")

# Create variables
g = m.addVar(lb=0, vtype=GRB.INTEGER, name="green_tea") # Number of green tea cups
b = m.addVar(lb=0, vtype=GRB.INTEGER, name="black_tea") # Number of black tea cups


# Set objective function
m.setObjective(2*g + 3*b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*g + 5*b <= 560, "time_constraint")
m.addConstr(g + b <= 150, "total_cups_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Green Tea Cups: {g.x}")
    print(f"Black Tea Cups: {b.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

