
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
G = m.addVar(lb=0, name="Green Tea")
B = m.addVar(lb=0, name="Black Tea")

# Define the objective function
m.setObjective(2*G + 3*B, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(3*G + 5*B <= 560, name="Time Constraint")
m.addConstr(G + B <= 150, name="Production Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Green Tea: {G.varValue}")
    print(f"Black Tea: {B.varValue}")
    print(f"Profit: ${2*G.varValue + 3*B.varValue:.2f}")
else:
    print("No optimal solution found.")
