
import gurobipy as gp

# Create a new model
m = gp.Model("EastOakDesigns")

# Create decision variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sofas")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cabinets")

# Set objective function
m.setObjective(400*x + 1200*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 10*y <= 100, "lacquer_constraint")
m.addConstr(10*x + 24*y <= 300, "oak_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Sofas: {x.x}")
    print(f"Number of Cabinets: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

