
from gurobipy import *

# Create a model
m = Model("East_Oak_Designs")

# Decision Variables
S = m.addVar(name="sofas", vtype=GRB.CONTINUOUS, lb=0)
K = m.addVar(name="kitchen_cabinets", vtype=GRB.CONTINUOUS, lb=0)

# Objective Function
m.setObjective(400*S + 1200*K, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*S + 10*K <= 100, name="lacquer_constraint")
m.addConstr(10*S + 24*K <= 300, name="oak_constraint")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Produce {S.x} sofas and {K.x} kitchen cabinets.")
else:
    print("No optimal solution found")
