
import gurobi

def east_oak_designs_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    S = model.addVar(lb=0, name="Sofa")
    K = model.addVar(lb=0, name="Kitchen_Cabinet")

    # Objective function: Maximize profit
    model.setObjective(400 * S + 1200 * K, gurobi.GRB.MAXIMIZE)

    # Lacquer constraint
    model.addConstr(3 * S + 10 * K <= 100, name="Lacquer_Constraint")

    # Oak constraint
    model.addConstr(10 * S + 24 * K <= 300, name="Oak_Constraint")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Sofas to produce: {S.varValue}")
        print(f"Kitchen cabinets to produce: {K.varValue}")
        print(f"Maximum profit: ${400 * S.varValue + 1200 * K.varValue}")
    else:
        print("No optimal solution found.")

# Run the optimization
east_oak_designs_optimization()
