
import gurobipy as gp

# Create a new model
model = gp.Model("PlushToyProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="small_plush") # Number of small plush toys
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="large_plush") # Number of large plush toys

# Set the objective function
model.setObjective(3*x + 5*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 8*y <= 250, "cotton_constraint")
model.addConstr(10*x + 12*y <= 500, "time_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small plush toys: {x.x}")
    print(f"Number of large plush toys: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

