
from gurobipy import *

# Create a model
m = Model("Plush_Toys")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="small_plush", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="large_plush", lb=0)

# Set the objective function
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + 8*y <= 250, "cotton_constraint")
m.addConstr(10*x + 12*y <= 500, "worker_time_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small plush toys: {x.x}")
    print(f"Large plush toys: {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
