
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
small_plush = model.addVar(lb=0, name="small_plush", vtype=gurobi.GRB.CONTINUOUS)
large_plush = model.addVar(lb=0, name="large_plush", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(3 * small_plush + 5 * large_plush, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(5 * small_plush + 8 * large_plush <= 250, name="cotton_constraint")
model.addConstr(10 * small_plush + 12 * large_plush <= 500, name="worker_time_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Small plush: {small_plush.x:.2f}")
    print(f"Large plush: {large_plush.x:.2f}")
    print(f"Max profit: {model.objVal:.2f}")
else:
    print("No optimal solution found.")
