
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Optimization")

# Create decision variables
x = m.addVar(nonnegative=True, name="wood_investment")
y = m.addVar(nonnegative=True, name="bamboo_investment")

# Set objective function
m.setObjective(0.07 * x + 0.03 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 10000, "total_investment")
m.addConstr(x >= 4 * y, "wood_multiple")
m.addConstr(x <= 7000, "max_wood")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in wood: ${x.x:.2f}")
    print(f"Optimal investment in bamboo: ${y.x:.2f}")
    print(f"Maximum average return: ${m.objVal:.2f}")
else:
    print("No solution found.")

